package aln.SpawnCommands;

import java.util.Arrays;
import java.util.List;

import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class CommandBack implements ICommand {
  
  @Override
  public int compareTo(Object arg0) {
    return 0;
  }
  
  @Override
  public String getCommandName() {
  //return "back";
	return Do.getConfigArrayValue(SpawnCommands.commandNames ,"back");
  }
  
  @Override
  public String getCommandUsage(ICommandSender icommandsender) {
    return "/"+Do.getConfigArrayValue(SpawnCommands.commandNames ,"back")+"     - Takes you back to where you were just before your last teleport or death.";
  }
  
  @Override
  public List getCommandAliases() {
    return Arrays.asList(new String[] { });
  }
  
  @Override
  public void processCommand(ICommandSender icommandsender, String[] params) {
    if(icommandsender instanceof EntityPlayer) {
      EntityPlayer player = (EntityPlayer) icommandsender;
      World world = player.worldObj;
      if ( world.isRemote ) { return; }
      
      SpawnCommands.loadCommandPermissionsConfig();
      SpawnCommands.loadMiscConfig();
      
      // command permissions. "no" is handled by not registering the command at all. "op" and "enable" are handled here. "all" is the default.
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "back").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
      { Do.Say(player,"Op only command.  You are not an op."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "back").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) 
      { Do.Say(player,"Advanced spawn commands are not enabled."); return; }
      
      if (params.length != 0) { SpawnCommands.showHelp(player); return; }
      
      // get player's location at start of this teleport request
      double  px = Math.round(player.posX - .5); // player's coordinates rounded down
      double  py = Math.round(player.posY - .5);
      double  pz = Math.round(player.posZ - .5);
      Float   pyaw = player.rotationYaw;
      Float   ppitch = player.rotationPitch;
      //Integer pdim = player.worldObj.provider.getDimensionId(); // mc1.8
      Integer pdim = player.worldObj.provider.dimensionId; // mc1.7.10
      Integer originDim = pdim;
      String newGoBackLocation = px +","+ py +","+ pz +","+ pyaw +","+ ppitch +","+ pdim;
      
      // get current destination
      //String filePathAndName = SpawnCommands.configBasePath+player.getName()+"/_"+player.getName()+"_GoBackLocation"; // mc1.8
      String filePathAndName = SpawnCommands.configBasePath+player.getGameProfile().getName()+"/_"+player.getGameProfile().getName()+"_GoBackLocation"; // mc1.7.10
      if ( ! Do.fileExists(filePathAndName)) { Do.Say(player,"No previous location on record where you either teleported from or died."); return; }
      String fileContent = Do.FileToString(filePathAndName);
      String[] fcValues = fileContent.split(",");
      if ( fcValues.length != 6 ) { Do.Say(player, "Internal Error: expected 6 values: x y z yaw pitch then dimensionID. Teleport failed."); return; }
      px =   Double.parseDouble(fcValues[0]);
      py =   Double.parseDouble(fcValues[1]);
      pz =   Double.parseDouble(fcValues[2]);
      pyaw =   Float.parseFloat(fcValues[3]);
      ppitch = Float.parseFloat(fcValues[4]);
      pdim =   Integer.parseInt(fcValues[5]);
      
      if ( originDim != pdim ) { // if changing dimensions
        // if in The End and the dragon is alive...
        boolean dragonIsAlive = false;
        if ( originDim == 1 ) { // if in The End ...
          for ( int k = 0; k < world.loadedEntityList.size(); k++ ) {
            Entity it = (Entity) world.loadedEntityList.get(k);
            if ( it instanceof EntityDragon ) { 
              dragonIsAlive = true;
              k = world.loadedEntityList.size();
            }
          }
        } // end dragon check          
        // if trying to go out of The End
        SpawnCommands.loadMiscConfig();
        if (( originDim == 1 ) && ( pdim != 1 ) && ( dragonIsAlive ) && (! Do.getConfigArrayValueBoolean(SpawnCommands.miscConfigArray, "AllowToLeaveTheDragon")) ) 
        { Do.Say(player,"The mighty dragon is in control of this world. You must defeat the dragon or death is your only escape!"); return; }
        // The following is a hack fix that overcomes a problem when directly leaving the end to any other dimension.
        // The problem: when you leave the end to another dimension the world will NOT load.
        // The solution: when you go to another dimension then go to a third one it WILL load, so we go to another one on the way.
        if ( ( originDim == 1 ) && ( pdim != 1 ) ) {
          if ( pdim == 0 ) { player.travelToDimension(-1); } else { player.travelToDimension(0); } 
        }
        player.travelToDimension(pdim); // officially change dimension now
      } // end if changing dimensions
      
      // write the location of the next go back command
      //if (! Do.StringToFile(SpawnCommands.configBasePath+player.getName()+"/_"+player.getName()+"_GoBackLocation", newGoBackLocation ) ) { // mc1.8
      if (! Do.StringToFile(SpawnCommands.configBasePath+player.getGameProfile().getName()+"/_"+player.getGameProfile().getName()+"_GoBackLocation", newGoBackLocation ) ) { // MC1.7.10
        Do.Err(player,"CommandBack: Could not create the file that stores the location to go back to.");
        return;
      }
      
      // don't spawn in solid blocks check
      while ( ( py < player.worldObj.getActualHeight() ) 
          &&  ( (!SpawnCommands.canSpawnInsideBlock(player, px, py, pz)) || (!SpawnCommands.canSpawnInsideBlock(player, px, py + 1, pz)) )
            ) 
      { py++; }
      // falling check
      while ( ( py > 1 ) 
          &&  ( (SpawnCommands.canSpawnInsideBlock(player, px, py - 1, pz)) && (SpawnCommands.canSpawnInsideBlock(player, px, py, pz)) )
            ) 
      { py--; }
      // lava under feet check
      // mc1.8
      //BlockPos posBelowFeet = new BlockPos(px, (py-1), pz);
      //if ((py>1) && ( ( player.worldObj.getBlockState(posBelowFeet).getBlock() == Blocks.lava) || ( player.worldObj.getBlockState(posBelowFeet).getBlock() == Blocks.flowing_lava) )) {
      //  player.worldObj.setBlockState(posBelowFeet, Blocks.cobblestone.getDefaultState());
      //}
      // mc1.7.10
      if ((py>1) && ( ( player.worldObj.getBlock((int)px, (int)(py-1), (int)pz) == Blocks.lava) || ( player.worldObj.getBlock((int)px, (int)(py-1), (int)pz) == Blocks.flowing_lava) )) {
        player.worldObj.setBlock((int)px, (int)(py-1), (int)pz, Blocks.cobblestone);
      }
      
      // actually go there now.
      ((EntityPlayerMP) player).playerNetServerHandler.setPlayerLocation(px + .5d, py, pz + .5d, pyaw, ppitch);
      return;
    }
  }

  @Override
  public boolean canCommandSenderUseCommand(ICommandSender icommandsender) {
    return true;
  }

  @Override
  //public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) { // mc1.8
  public List addTabCompletionOptions(ICommandSender icommandsender, String[] astring) { // mc1.7.10
    return null;
  }

  @Override
  public boolean isUsernameIndex(String[] astring, int i) {
    return false;
  }

}
